% savespectrum.m
% ----------------------------------------------------------------------
% A script to save the measurement data from the Agilent 8563EC spectrum
% analyzer into a text file via an Agilent 82357B USB/GPIB Interface
% adapter.
%
% Lai Bun Lok, 29th May 2014

clear all

% Board index here is 7 (PC dependent?), and GPIB address is 4 (adjustable)
g=gpib('agilent',7,4,'InputBufferSize',30000);
fopen(g)
% Annoyingly, the fopen command also resets the analyzer to full span
% and default settings, so you'll need to manually set your measurement
% conditions on the analyzer again. Hence the wait below
input('Hit <LCL> on analyzer, set up your measurement,\n and Press <ENTER> when you are ready to capture','s');

% Now sequentially probe the instrument's measurement configuration and save
% the information into the workspace
fprintf(g,'ID?');
idn=fscanf(g);
fprintf(g,'SER?');
serialno=fscanf(g);
fprintf(g,'REV?');
firmware=fscanf(g);
fprintf(g,'FA?');
freqstart=fscanf(g);
fprintf(g,'FB?');
freqstop=fscanf(g);
fprintf(g,'RL?');
reflevel=fscanf(g);
fprintf(g,'AUNITS?');
ampunits=fscanf(g);
fprintf(g,'LG?');
dBperDiv=fscanf(g);
fprintf(g,'RB?');
rbw=fscanf(g);
fprintf(g,'VB?');
vbw=fscanf(g);
fprintf(g,'ST?');
sweeptime=fscanf(g);
% Then transfer the measurement data
fprintf(g,'TDF P;TRA?');
meas=fscanf(g);

% Release the GPIB object
fclose(g);


% Save the captured data into a text file, along with the header info
fid=fopen('spectrum.txt','w');
fprintf(fid,'Instrument ID: %s', idn);
fprintf(fid,'Firmware: %s', firmware);
fprintf(fid,'Serial Number: %s', serialno);
fprintf(fid,'Start frequeny (Hz): %s',freqstart);
fprintf(fid,'Stop frequency (Hz): %s',freqstop);
fprintf(fid,'Amplitude Units: %s',ampunits);
fprintf(fid,'Reference Level: %s',reflevel);
fprintf(fid,'dB_per_division: %s',dBperDiv);
fprintf(fid,'Resolution Bandwidth (Hz): %s',rbw);
fprintf(fid,'Video Bandwidth (Hz): %s',vbw);
fprintf(fid,'Sweep Time in seconds %s', sweeptime);
fprintf(fid,'%s',meas); % The Data
fclose(fid);

% Plot the captured data
data=csvread('spectrum.txt',11,0);
x=[str2num(freqstart):(str2num(freqstop)-str2num(freqstart))/600:str2num(freqstop)];
plot(x,data)
xlabel('Frequency (Hz)')
ylabel(ampunits)

