clear all;
close all;

c=3e8;
% f=2.44e9;
% er=4.3;
% h=1.6e-3;

prompt={'Enter frequency (Hz):','Enter your er of substrate:','Enter your height of substrate (mm):'};
% Create all your text fields with the questions specified by the variable prompt.
title='Patch antenna dimension calculator'; 
% The main title of your input dialog interface.
answer=inputdlg(prompt,title);
f = str2double(answer{1}); 
er = str2double(answer{2});
h= str2double(answer{3});
h=h*1e-3;
lambda_0=c/f;
w=((c/(2*f))*((er+1)/2)^-.5);
eeff= ((er+1)/2)+(((er-1)/2)*(1+(12*h/w))^-.5);
del_l=0.412*h*(((eeff+.3)/(eeff-0.258))*(((w/h)+0.264)/((w/h)+0.8)));
l=((c/(2*f*(eeff)^.5))-(2*del_l));

fprintf('Width of patch= %g mm\n', w*1000);
fprintf('del_L = %g mm\n', del_l*1000);
fprintf('Length of patch = %g mm\n', l*1000);

